%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% Funkcija racuna inverznu matricu Gausovom metodom matrice A
% Podrazumeva se da je matrica A kvadratna, jer funkciju poziva program koji to proverava
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function INVERZ=gaus_inverz(A)
  dim=size(A,1);      % dimenzija matrice
  PREMESTANJA=[];     % kolona koja pamti premestanja promenljivih X
  INVERZ=zeros(dim);  % inverz

  for brVektora=1:dim
    MATRICA=A;
    % postavljanje pocetnog redosleda indeksa nepoznatih: x1, ... xn, n=1..dim
    for i=1:dim
      PREMESTANJA(1,i)=i;
    end
    % dodavanje E kolone
    for i=1:dim
      if i==brVektora
        MATRICA(i,dim+1)=1;
      else
        MATRICA(i,dim+1)=0;
      end
    end
    for i=1:dim-1
      [a,b]=pivot(MATRICA,i,dim); % pronalazi se pivot
      if (a~=i) | (b~=i)          % nema zamene ako je pivot na odgovarajucem mestu
        MATRICA=zamniVK(MATRICA,i,a,b); % zamena "pivot" vrste i kolone sa odgovarajucom i-tom vrstom i kolonom
        PREMESTANJA(1,:)=zamena_kolona(PREMESTANJA(1,:), i, b); % promena promenljive X-kolone
      end
      % ponistavanje
      for k=i+1:dim
        mKoef=MATRICA(k,i)./MATRICA(i,i);
        for j=i:dim+1
          MATRICA(k,j)=MATRICA(k,j)-MATRICA(i,j).*mKoef;
        end
      end
    end
    INVERZ(:,brVektora)=kolona_nepoznatih(MATRICA, PREMESTANJA, dim);
  end
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% Funkcija zamenjuje p-vrstu i p-kolonu sa v-vrstom i k-kolonom matrice A
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function M=zamniVK(A,p,v,k)
  M=A;
  if k~=1
    kTemp=M(:,p);   % privremeno cuvanje prve kolone
    M(:,p)=M(:,k);
    M(:,k)=kTemp;
  end
  if v~=1           % privremeno cuvanje prve kolone
    vTemp=M(p,:);
    M(p,:)=M(v,:);
    M(v,:)=vTemp;
  end
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% Funkcija izracunava vrednost nepoznatih. Vrednost vraca kao kolonu.
% A - prosirena matrica, P - premestanja, d - dimenzija matrice
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function M=kolona_nepoznatih(A,P,d)
  X=zeros(1,d);
  M=zeros(d,1);
  X(1,d)=A(d,d+1)./A(d,d);
  for i=d-1:-1:1
    ZBIR=0;
    for j=d:-1:i+1
      ZBIR=ZBIR+X(1,j).*A(i,j);
    end
    X(1,i)=(A(i,d+1)-ZBIR)./A(i,i);
  end
  for i=1:d
    M(P(1,i),1)=X(1,i);
  end
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% Funkcija pronalazi PIVOT (potpuno pivotiranje)
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function [v,k]=pivot(A,p,d)
  maxP=abs(A(p,p));
  v=p;
  k=p;
  for i=p:d
    for j=p:d
      if abs(A(i,j))>maxP
        v=i;
        k=j;
        maxP=abs(A(i,j));
      end
    end
  end